//
//  MCPInstanceCache.h
//  MCPersistence
//
//  Created by aj on Fri Dec 21 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>

@class MCPEntity;
@class MCPObject;

@interface MCPInstanceCache : NSObject {

	NSMutableDictionary		*_cache;
	
	NSTimer					*_flushTimer;

}

- (NSArray *)objectsForEntity:(MCPEntity *)entity;

- (NSArray *)objectsForEntity:(MCPEntity *)entity
           whereAttributeName:(NSString *)attrib isEqualToString:(NSString *)anObj;

- (id)objectForPrimaryKey: (id)pkey entity: (MCPEntity*)entity;
	// Does the necessary work to create the primary key string value to call into the method objectForPrimaryKeyString:entity:

- (id)objectForPrimaryKeyString:(NSString *)key entity:(MCPEntity *)entity;

- (void)registerObject:(id)anObj withPrimaryKeyString:(NSString *)key entity:(MCPEntity *)entity;

- (void)forgetObjectWithPrimaryKeyString:(NSString *)key entity:(MCPEntity *)entity;
- (void)forgetAllObjectsForEntity:(MCPEntity *)entity;
- (void)forgetAllObjectsForEntityNamed:(NSString *)entityName retainThreshold:(int)val;
- (void)forgetObject:(MCPObject *)object shouldForgetOwnedObjects:(BOOL)forgetOwnedObjects;
- (void)forgetObject:(MCPObject *)object;

- (void)flushUnusedObjects:(NSTimer *)timer;

- (void)prepareForRelease;



// These methods were added so that we could clear the EOs totally in Daylite on the sync thread
- (void)emptyCache;

@end
